<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dir="http://apache.org/cocoon/directory/2.0">
   	<xsl:import href="../docbook-xsl-1.65.1/xhtml/docbook.xsl" />
   	<xsl:param name="cssfile"/>
  	<xsl:template match="page">
      	<html>
        	<head>
			<link rel="stylesheet" href="{$cssfile}" type="text/css"/>
			<title>INJAC</title>
        	</head>
		<body>
            		<xsl:apply-templates />
        	</body>
      	</html>
   	</xsl:template>
   
   	<xsl:template match="styleCss">
	<div id="listeCSS">
        	<form>
            		<select name="stylesheetList" onchange="javascript:location.href=(this.options[this.selectedIndex].value)">
               			<xsl:apply-templates select="cssName" />
            		</select>
         	</form>
      	</div>
   	</xsl:template>

   	<xsl:template match="cssName">
      	<option value=".?cssfile={.}">
         	<xsl:value-of select="."/>
      	</option>
   	</xsl:template>
   
   	<xsl:template match="dirgen">
      	<div id="leftMenu">
      		<ul type="disc" id="currentFolder">
         		<xsl:apply-templates />
		</ul>
      	</div>
   	</xsl:template>

   	<xsl:template match="current">   	  
	<div align="left"><h4>Collection courante : <xsl:value-of select="name"/></h4></div>
   	</xsl:template>
   
   	<xsl:template match="directories">
	<div align="left"><h4>Collections :</h4></div>
	<xsl:apply-templates />
   	</xsl:template>
	
   	<xsl:template match="files">
	<div align="left"><h4>Resources :</h4></div>
	<xsl:apply-templates />
   	</xsl:template>

 
 
   	<xsl:template match="directory">
       	<li class="directory">		
		<a href="./{name}/?cssfile={$cssfile}">
			<xsl:value-of select="name" />
		</a>
		<ul type="circle">
			<li id="fileDate">creation : <xsl:value-of select="date" /></li>
			<li id="fileDate">modification : <xsl:value-of select="lastModified" /></li>
		</ul>
      	</li>
   	</xsl:template>

   	<xsl:template match="file">
      	<li class="file">
		<a href="./{name}?cssfile={$cssfile}&amp;path={name}">
			<xsl:value-of select="name" />
		</a>
        	<ul type="circle">
			<li id="fileDate">creation : <xsl:value-of select="date" /></li>
			<li id="fileDate">modification : <xsl:value-of select="lastModified" /></li>
			<li id="fileSize">taille : <xsl:value-of select="size" /> octets</li>
		</ul>
      	</li>
      
   	</xsl:template>
   
   	<xsl:template match="article">
   		 <div id="docbookDocument">
   		 	<xsl:apply-imports/>
         	</div>
   	</xsl:template>      

</xsl:stylesheet>

